PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144685124"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = "Case3.snp"
  OFile = "noname.out"
  SFile = "Case3.snp"
  SnapTime = 0.2
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144684901
  Nodes = 
   {
   Output("FTime",36,0)
    {
    Type = Real
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("Fdur",36,36)
    {
    Type = Real
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("FType",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-42,27,43)
   Pen(Gray)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,0,36,0)
   Line(27,36,34,36)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.export([1530,1134],4,0,320)
    {
    Name = "F"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1440,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1440,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(66796024)
    Meter(66821552)
    Slider(66615384)
    Meter(66742864)
    Meter(66840640)
    Meter(66625928)
    Meter(66895816)
    Meter(66726488)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(66753472)
    Dial(66779064)
    Slider(66002720)
    Slider(66005576)
    Slider(66844920)
    }
   0.datalabel([1548,720],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1548,774],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1548,828],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1440,990],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1440,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1440,1026],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1440,1044],6,0,-1)
    {
    Name = "B4"
    }
   0.datamerge([1458,1062],4,0,310)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([1494,1080],4,0,330)
    {
    Name = "B"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1278,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(65955976)
    Slider(65974960)
    Slider(65968264)
    }
   -ControlPanel-([1278,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(65959944)
    Slider(65971040)
    Slider(65994456)
    }
   0.datalabel([1548,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1278,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(65981768)
    Slider(65987672)
    Slider(65913680)
    }
   -ControlPanel-([1278,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(65990144)
    Slider(65910824)
    Slider(65907672)
    }
   0.var([1512,882],0,65907672,150)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,828],0,65910824,130)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,774],0,65913680,120)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,240)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(66789288)
    Meter(66815544)
    Slider(66786432)
    Meter(66739672)
    Meter(66748824)
    Meter(66629024)
    Meter(66783520)
    Meter(66723576)
    }
   -Wire-([1782,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1818,324],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1854,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,288],0,65955976,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1962,324],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1854,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,450],6,65959944,50)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1890,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1962,468],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1728,324],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1728,504],4,0,70)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1548,342],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1548,396],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1548,450],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1512,396],0,65968264,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,450],0,65971040,40)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1548,504],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1512,342],0,65974960,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.logic([1926,324],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1782,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1818,882],6,0,280)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1746,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([1818,702],0,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1854,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,666],0,65981768,100)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1854,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1890,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1962,702],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1962,846],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1512,720],0,65987672,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1854,828],6,65990144,140)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([1926,846],0,0,300)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1728,882],4,0,160)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1512,504],0,65994456,60)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1728,702],4,0,250)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([1926,468],0,0,290)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1782,738],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1656,792],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;0,378"
    }
   0.logic([1818,504],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1926,702],6,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.var([612,684],0,66002720,80)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([612,720],0,66005576,90)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   -Sticky-([252,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,882,378,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No fault
11=> No fault (0)"
    }
   -Sticky-([72,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,882,216,1206
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([1278,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,162,1386,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([1440,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1440,162,1602,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Sticky-([1278,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,990,1386,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([936,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,126,1044,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback  Recorders"
    }
   -ControlPanel-([936,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(66853112)
    Slider(66413960)
    }
   -ControlPanel-([864,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(66863600)
    Switch(66866792)
    Switch(66869384)
    Switch(66872272)
    }
   -Sticky-([882,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,468,1134,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   0.import([1620,414],0,0,-1)
    {
    Name = "FType"
    }
   0.datalabel([1440,1170],6,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([1440,1206],6,0,-1)
    {
    Name = "Tfd"
    }
   -Wire-([1440,1170],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1440,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.import([1638,1098],0,0,170)
    {
    Name = "FType"
    }
   0.export([1530,1170],2,0,180)
    {
    Name = "FTime"
    }
   0.export([1530,1206],2,0,190)
    {
    Name = "FDur"
    }
   -Sticky-([846,630],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,630,1152,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence

NOTE:  Breakers are disabled when the Doble
State component is enabled.  

Fault is located on Line 2 at B3 (Fault location 5)
Fault is AB to Ground (Fault Type 4)

Fault occurs at  0.20 sec, Fault Duration 0.05 sec

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B1 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.40:  Breaker B4 trips in 40 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B1 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose
B4T2 =  2.00:  Breaker B4 does not reclose

(Breaker  B1  and B2  do not automatically operate)
"
    }
   -Divider-([1206,936],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([36,594],0)
    {
    Size(1170,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([810,90],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1206,90],0)
    {
    Size(0,1422)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,36],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,756,1152]
    Posn = [18,36]
    Icon = [-1,-1]
    Extents = 0,0,756,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(66686032,"V3a",0,,,)
     Curve(66917080,"V3b",1,,,)
     Curve(66688888,"V3c",2,,,)
     }
    Graph([0,277],[0,0,756,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(66691800,"I3a",0,,,)
     Curve(66694712,"I3b",1,,,)
     Curve(66697600,"I3c",2,,,)
     }
    Graph([0,554],[0,0,756,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(66700512,"I30",0,,,)
     }
    PGraph([0,831],[0,0,756,258],"PolyGraph")
     {
     Options = 2
     Curve(66715240,"Br3a",0,,,1)
     Curve(66718024,"Br3b",1,,,1)
     Curve(66720800,"Br3c",2,,,1)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,756,1152]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,756,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(66736896,"V1a",0,,,)
     Curve(66904432,"V1b",1,,,)
     Curve(66569576,"V1c",2,,,)
     }
    Graph([0,277],[0,0,756,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(66936192,"I1a",0,,,)
     Curve(66645352,"I1b",1,,,)
     Curve(66631936,"I1c",2,,,)
     }
    Graph([0,554],[0,0,756,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(66635688,"I10",0,,,)
     }
    PGraph([0,831],[0,0,756,258],"PolyGraph")
     {
     Options = 2
     Curve(66577984,"Br1a",0,,,1)
     Curve(66585816,"Br1b",1,,,1)
     Curve(66621080,"Br1c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(66572488,"V2a",0,,,)
     Curve(66922888,"V2b",1,,,)
     Curve(66928712,"V2c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(66566800,"I2a",0,,,)
     Curve(66911160,"I2b",1,,,)
     Curve(66642272,"I2c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(66639496,"I20",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(66582280,"Br2a",0,,,1)
     Curve(66588456,"Br2b",1,,,1)
     Curve(66898672,"Br2c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(66925800,"V4a",0,,,)
     Curve(66703424,"V4b",1,,,)
     Curve(66837504,"V4c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(66706336,"I4a",0,,,)
     Curve(66709416,"I4b",1,,,)
     Curve(66712328,"I4c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(66931624,"I40",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(66385056,"Br4a",0,,,1)
     Curve(66729576,"Br4b",1,,,1)
     Curve(66732296,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144684901
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2322,1368],0,66385056,920)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([486,1170],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([522,1170],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([558,1170],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([486,1350],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([522,1350],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([558,1350],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1566,1224],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1584,1260],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1584,1296],0,0,390)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([378,1170],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([414,1170],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([450,1170],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([378,1350],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([414,1350],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([450,1350],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2286,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1746,1332],0,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,1296],0,0,430)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1746,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,1332],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1584,1332],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1584,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1584,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1584,1332],0,0,470)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,1260],0,0,370)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1728,1224],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([252,1278],0,66413960,210)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.55"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1278,1134],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1224,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1260,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1242,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1188,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1224,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1260,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1278,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1998,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([792,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([306,540],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([324,648],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([324,666],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([1602,1476],0,66545896,540)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1602,1512],0,66548672,560)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([774,450],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([774,468],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([774,684],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([774,702],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1314,1134],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1242,1134],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1332,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1368,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([900,432],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "69.89 [MW]"
    Q = "-16.31 [MVAR]"
    }
   0.datalabel([540,450],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([540,468],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([540,684],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([522,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([486,432],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([846,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([324,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([846,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1998,1476],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([2034,1440],0,66566800,840)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1638,1188],0,66569576,280)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1800,1116],0,66572488,200)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([2160,1080],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([2160,1116],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([2160,1152],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([2196,1080],0,66577984,1280)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2286,1080],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([2286,1116],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([2322,1080],0,66582280,1270)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2160,1206],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([2196,1116],0,66585816,1250)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2322,1116],0,66588456,1210)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1584,1116],0,0,160)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1584,1152],0,0,220)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1566,1080],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1602,1116],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1602,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1764,1152],2,0,-1)
    {
    Name = "V2B"
    }
   -Wire-([2160,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,1278],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([2160,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,1314],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([2286,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1314],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1764,1116],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2286,1278],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([2286,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1242],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([2286,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1206],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([2286,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1152],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1998,1512],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1998,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1998,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1188],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1746,1188],0,0,300)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,1152],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1746,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1602,1188],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1584,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1584,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1584,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1584,1188],0,0,270)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2160,1242],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([2196,1152],0,66621080,1140)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1746,1116],0,0,190)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1728,1080],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1728,1080],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2322,1242],0,66625928,1050)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2196,1242],0,66629024,1080)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1818,1512],0,66631936,790)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1998,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1818,1548],0,66635688,730)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.3"
    }
   0.datalabel([1998,1548],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([2034,1548],0,66639496,710)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.4"
    }
   0.pgb([2034,1512],0,66642272,760)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1818,1476],0,66645352,830)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1566,1080],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1782,1548],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1566,1224],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1602,1260],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1602,1296],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1602,1332],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1764,1260],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1764,1296],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1764,1332],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([900,1170],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([936,1170],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([972,1170],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([900,1350],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([936,1350],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([972,1350],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1998,1296],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1998,1332],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1998,1368],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1998,1116],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1998,1152],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1998,1188],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([1008,1170],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1044,1170],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1080,1170],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1008,1350],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1044,1350],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1080,1350],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([558,1314],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,1494],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1080,1314],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2160,1494],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2160,1530],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2160,1368],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2160,1404],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2160,1440],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2286,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1368],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2286,1404],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2286,1440],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2286,1494],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2286,1530],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1638,1260],0,66686032,350)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1638,1332],0,66688888,490)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2034,1260],0,66691800,1070)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([2034,1296],0,66694712,1030)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([2034,1332],0,66697600,990)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([2034,1368],0,66700512,960)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.pgb([1800,1296],0,66703424,450)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2034,1080],0,66706336,1300)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2034,1116],0,66709416,1260)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2034,1152],0,66712328,1180)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2196,1368],0,66715240,950)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2196,1404],0,66718024,860)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2196,1440],0,66720800,820)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2196,1530],0,66723576,720)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2322,1530],0,66726488,700)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2322,1404],0,66729576,850)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2322,1440],0,66732296,810)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([540,702],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1350,1134],2,0,-1)
    {
    Name = "B4"
    }
   0.pgb([1638,1116],0,66736896,180)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1602,1404],0,66739672,520)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([828,432],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.pgb([1602,1440],0,66742864,530)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([378,540],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([936,540],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([972,666],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([972,648],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([990,540],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2196,1206],0,66748824,1100)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([324,1278],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([846,1278],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.datalabel([1206,1152],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([1170,1350],0,66753472,420)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1242,1350],0,0,440)
    {
    IType = "2"
    OType = "1"
    }
   0.mux_array([1260,1422],6,0,610)
    {
    DPath = "0"
    }
   -Wire-([1332,1152],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([1242,1134],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1278,1134],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1314,1134],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1350,1134],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1224],6,0,1230)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1224],6,0,1220)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1224],6,0,1200)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1296,1224],6,0,1190)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1332,1224],6,0,1170)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1368,1224],6,0,1160)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1296,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1350,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1188,1476],0,0,940)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1476],0,0,930)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1476],0,0,910)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1296,1476],0,0,900)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1332,1476],0,0,890)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1368,1476],0,0,880)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1368,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1332,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1350,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1296,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.var_pot([1350,1350],2,66779064,460)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([1278,1350],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([1278,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([2196,1494],0,66783520,770)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.var([162,612],3,66786432,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([216,612],3,66789288,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1116,612],5,66615384,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1062,612],5,66796024,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.source3R([198,540],6,0,570)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([1242,1530],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1314,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([504,666],0,0,1330)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1008,630],4,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([288,630],0,0,1340)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.breaker3([414,432],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-68.54 [MW]"
    Q = "3.788 [MVAR]"
    }
   0.datalabel([1728,1224],2,0,-1)
    {
    Name = "V4"
    }
   0.tpflt([810,666],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([504,432],0,0,1380)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1080,1494],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([1206,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([2196,1278],0,66815544,1040)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2196,1314],0,66818640,1000)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2322,1278],0,66821552,1020)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2322,1314],0,66824464,970)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.tpflt([810,432],4,0,1360)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Bus-([378,414],0,38901456,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([936,396],0,38902000,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([414,648],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-68.54 [MW]"
    Q = "8.294 [MVAR]"
    }
   0.breaker3([900,648],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "69.91 [MW]"
    Q = "-16.28 [MVAR]"
    }
   0.pgb([1800,1332],0,66837504,510)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2322,1206],0,66840640,1090)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Sticky-([1404,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1404,1116,1512,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1260,1278],0,0,1110)
    {
    DPath = "0"
    }
   0.var([1206,1530],0,66844920,550)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = ".001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   -Wire-([846,1566],0,0,-1)
    {
    Vertex="0,0;-522,0"
    }
   0.const([90,1206],1,0,130)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([126,1242],6,0,150)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([90,1386],1,0,320)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([126,1422],6,0,360)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([684,1206],1,0,170)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([684,1386],1,0,400)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([18,1152],0,66853112,110)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([54,1152],0,0,-1)
    {
    Vertex="0,0;0,306"
    }
   -Wire-([54,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([54,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([162,1422],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([162,1242],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.select([720,1242],6,0,230)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([630,1098],0,0,-1)
    {
    Vertex="0,0;-576,0"
    }
   -Wire-([756,1242],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([630,1458],0,0,-1)
    {
    Vertex="0,0;0,-360"
    }
   -Wire-([288,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([54,1098],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([630,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([630,1458],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([720,1422],6,0,480)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([756,1422],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.var_switch([126,1170],1,66863600,120)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([126,1350],1,66866792,290)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([720,1170],1,66869384,140)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([720,1350],1,66872272,340)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1800,216],2,0,-1)
    {
    Name = "I1"
    }
   -Wire-([1800,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,162],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2088,216],2,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1800,144],0,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([2088,144],0,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([1800,162],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([2088,162],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([1260,972],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1224,954],6,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([1224,990],6,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([1260,936],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1314,990],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([1314,972],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1314,954],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([1260,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1278,1350],1,0,-1)
    {
    Name = "FType"
    }
   0.datalabel([1782,1440],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1800,270],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([1800,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1800,288],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([2088,270],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([2088,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2088,288],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([2088,342],2,0,-1)
    {
    Name = "I4"
    }
   0.datalabel([1800,342],2,0,-1)
    {
    Name = "I3"
    }
   0.datalabel([1782,1512],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1782,1476],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1224,918],6,0,-1)
    {
    Name = "Breaker"
    }
   -Wire-([1314,918],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.pgb([2322,1494],0,66895816,740)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2322,1152],0,66898672,1130)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Wire-([1764,1440],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1764,1494],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1764,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1764,1476],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1764,1512],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1746,1530],0,0,-1)
    {
    Name = "I1"
    }
   0.pgb([1638,1152],0,66904432,240)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1998,1440],2,0,-1)
    {
    Name = "I2A"
    }
   -Wire-([1980,1440],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1494],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1476],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1512],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1962,1530],0,0,-1)
    {
    Name = "I2"
    }
   0.pgb([2034,1476],0,66911160,800)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   -Wire-([1980,1260],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1314],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1296],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1998,1260],2,0,-1)
    {
    Name = "I3A"
    }
   0.pgb([1638,1296],0,66917080,410)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1998,1080],2,0,-1)
    {
    Name = "I4A"
    }
   -Wire-([1980,1080],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1134],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1980,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,1152],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([1800,1152],0,66922888,260)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1800,1260],0,66925800,380)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1800,1188],0,66928712,310)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2034,1188],0,66931624,1120)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.4"
    }
   0.datalabel([1962,1170],0,0,-1)
    {
    Name = "I4"
    }
   0.datalabel([1962,1350],0,0,-1)
    {
    Name = "I3"
    }
   0.pgb([1818,1440],0,66936192,870)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1800,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,162],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,198],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2088,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,198],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1800,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -SrcFile-([2286,270],0)
    {
   Name = "\\case3_state.emt\\out4.ss1"
    }
   -TLine-([540,432],0,38962832,-1)
    {
    Name = "LINE1"
    Date = 1144684902
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_Ground([630,702],0,38965184,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,126],0,38966320,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,38967264,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,38967688,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([540,648],0,115514576,-1)
    {
    Name = "LINE2"
    Date = 1144684903
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_Ground([630,702],0,115515768,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,126],0,115516704,-1)
      {
      Mode = "1"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,115517728,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,115518296,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([828,648],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([486,648],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.source3R([1080,540],2,0,580)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   .Plots_B2([900,306],0,0,20)
    {
    }
   -Sticky-([1026,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 1026,612,1152,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([144,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 144,612,252,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -SrcFile-([1998,270],0)
    {
   Name = "\\case3_state.emt\\out3.ss1"
    }
   -SrcFile-([2286,144],0)
    {
   Name = "\\case3_state.emt\\out2.ss1"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,522,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via 
   two parallel 100km transmission lines.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   0.datalabel([1800,198],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1800,324],2,0,-1)
    {
    Name = "V3"
    }
   -Wire-([2088,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2088,324],2,0,-1)
    {
    Name = "V4"
    }
   0.datalabel([2088,198],2,0,-1)
    {
    Name = "V2"
    }
   0.doblestate([1944,306],0,0,1370)
    {
    filename = "out3.ss1"
    Cmnt = "Case 3 Station 3"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.doblestate([2232,306],0,0,1350)
    {
    filename = "out4.ss1"
    Cmnt = "Case 3 Station 4"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.doblestate([2232,180],0,0,1390)
    {
    filename = "out2.ss1"
    Cmnt = "Case 3 Station 2"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.datamerge([1746,1530],0,0,780)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1962,1530],0,0,750)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1962,1350],0,0,980)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1962,1170],0,0,1150)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   .Plots_B1([414,306],0,0,10)
    {
    }
   .Controls([1350,954],4,0,600)
    {
    }
   -SrcFile-([1998,144],0)
    {
   Name = "\\case3_state.emt\\out1.ss1"
    }
   0.doblestate([1944,180],0,0,1400)
    {
    filename = "out1.ss1"
    Cmnt = "Case 3 Station 1"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.recorder2_0([450,1242],0,0,1290)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([450,1422],0,0,1060)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([972,1242],0,0,1240)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([972,1422],0,0,1010)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Sticky-([540,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,18,936,126
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   0.multimeter([468,432],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([468,648],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([846,648],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([846,432],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Divider-([18,1044],0)
    {
    Size(2394,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1422,36],0)
    {
    Size(0,1008)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Wire-([1566,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1404],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1566,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1440],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1566,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1476],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1566,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1512],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

